// Korekcja perspektywy
// Shader wierzchokw
// Graham Sellers
// OpenGL. Ksiga eksperta
#version 150

precision highp float;

// Dane przychodzce wierzchokw  pooenie i wsprzdne tekstury
in vec4 vVertex;
in vec2 vTexCoord;

// Zwyka wsprzdna tekstury
out vec2 texcoord;
// Wsprzdna tekstury bez perspektywy
noperspective out vec2 texcoordNoPerspective;

uniform mat4 mvpMatrix;

void main(void)
{
    // Iloczyn skalarny daje intensywno rozproszenia
    texcoord = vTexCoord;
    texcoordNoPerspective = vTexCoord;
    gl_Position = mvpMatrix * vVertex;
}
